return helicopter( "AH-64A", _("AH-64A"),
    {
        
        EmptyWeight = "5345",
        MaxFuelWeight = "1157",
        MaxHeight = "6400",
        MaxSpeed = "300",
        MaxTakeOffWeight = "9225",
        Picture = "AH-64A.png",
        Rate = "50",
        Shape = "AH-64A",
        WorldID = 157,
		TakeOffRWCategories = 
        {
	            [1] = 
	            {
	                Name = "AircraftCarrier",
	            }, -- end of [1]
	            [2] = 
	            {
	                Name = "HelicopterCarrier",
	            }, -- end of [2]
        }, -- end of TakeOffRWCategories
                                
        -- Countermeasures,  2xM-160 = 60 Chaffs/Flares (60)
        SingleChargeTotal = 60,
        CMDS_Incrementation = 30,
        ChaffDefault = 30, 
        ChaffChargeSize = 1,
        FlareDefault = 30, 
        FlareChargeSize = 1,
        CMDS_Edit = true,
        
        attribute = {wsType_Air, wsType_Helicopter, wsType_Battleplane, AH_64A,
        "Attack helicopters",
        },
        Categories = {
        },
        Crew = 2,
        CanopyGeometry = {
            azimuth = {-165.0, 165.0},
            elevation = {-80.0, 90.0}
        },
		ViewSettings = {
		Cockpit = {
		[1] = {-- player slot 1
		CockpitLocalPoint      = {3.100000,-0.200000,0.000000},
		CameraViewAngleLimits  = {20.000000,90.000000},
		CameraAngleRestriction = {false,90.000000,0.500000},
		CameraAngleLimits      = {160.000000,-75.000000,90.000000},
		EyePoint               = {0.090000,0.000000,0.000000},
		limits_6DOF            = {x = {-0.020000,0.350000},y ={-0.150000,0.165000},z = {-0.170000,0.170000},roll = 90.000000},
		},
		}, -- Cockpit 
		Chase = {
		LocalPoint      = {-0.512000,2.790000,0.000000},
		AnglesDefault   = {180.000000,-8.000000},
		}, -- Chase 
		Arcade = {
		LocalPoint      = {-16.812000,5.390000,0.000000},
		AnglesDefault   = {0.000000,-8.000000},
		}, -- Arcade 
		},
        Sensors = {
            OPTIC = {"TADS DTV", "TADS DVO", "TADS FLIR"},
            --OPTIC = {"PNVS", "TADS DTV", "TADS DVO", "TADS FLIR"},
            RWR = "Abstract RWR"
        },
        Countermeasures = {
            DISPENSER = "UV-26"
        },
		HumanRadio = {
			frequency = 124.0,
			editable = true,
			minFrequency = 100,
			maxFrequency = 400,
			modulation = MODULATION_AM
		},		
        Failures = {
            { id = 'hydro_main',  label = _('HYDRO MAIN'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
            { id = 'hydro_common',  label = _('HYDRO COMMON'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
            { id = 'l_engine',  label = _('L-ENGINE'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
            { id = 'r_engine',  label = _('R-ENGINE'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
            { id = 'asc_p',  	label = _('ASC PITCH'), 	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
            { id = 'asc_r',  	label = _('ASC ROLL'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
            { id = 'asc_y',  	label = _('ASC YAW'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
            { id = 'asc_a',  	label = _('ASC ALT'), 		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'abris_software',  	label = _('ABRIS SOFTWARE'),	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
 			{ id = 'abris_hardware',  	label = _('ABRIS HARDWARE'),	enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
			{ id = 'laser_failure' ,  	label = _('LASER FAILURE'),		enable = false, hh = 0, mm = 0, mmint = 1, prob = 100 },
       },
	   	EPLRS = true,
        mapclasskey = "P0091000021",
    },
    {
        pylon(1, 0, 0.288000, -0.976000, -2.425000,
            {
                FiZ = 0,
            },
            {
                { CLSID = "{FD90A1DC-9147-49FA-BF56-CB83EF0BD32B}" },
                { CLSID = "{88D18A5E-99C8-4B04-B40B-1C02F2018B6E}" },
                { CLSID = "{FD90A1DC-9147-49FA-BF56-CB83EF0BD32B}" },
            }
        ),
        pylon(2, 0, 0.288000, -0.976000, -1.685000,
            {
                FiZ = 0,
            },
            {
                { CLSID = "{FD90A1DC-9147-49FA-BF56-CB83EF0BD32B}" },
                { CLSID = "{3DFB7321-AB0E-11d7-9897-000476191836}" },
                { CLSID = "{88D18A5E-99C8-4B04-B40B-1C02F2018B6E}" },
                { CLSID = "{FD90A1DC-9147-49FA-BF56-CB83EF0BD32B}" },
            }
        ),
        pylon(3, 0, 0.288000, -0.976000, 1.685000,
            {
                FiZ = 0,
            },
            {
                { CLSID = "{FD90A1DC-9147-49FA-BF56-CB83EF0BD32B}" },
                { CLSID = "{3DFB7321-AB0E-11d7-9897-000476191836}" },
                { CLSID = "{88D18A5E-99C8-4B04-B40B-1C02F2018B6E}" },
                { CLSID = "{FD90A1DC-9147-49FA-BF56-CB83EF0BD32B}" },
            }
        ),
        pylon(4, 0, 0.288000, -0.976000, 2.425000,
            {
                FiZ = 0,
            },
            {
                { CLSID = "{FD90A1DC-9147-49FA-BF56-CB83EF0BD32B}" },
                { CLSID = "{88D18A5E-99C8-4B04-B40B-1C02F2018B6E}" },
                { CLSID = "{FD90A1DC-9147-49FA-BF56-CB83EF0BD32B}" },
            }
        ),
    },
    {
        aircraft_task(CAS),
        aircraft_task(GroundAttack),
		aircraft_task(Escort),
        aircraft_task(AFAC),
        aircraft_task(AntishipStrike)
    },
	aircraft_task(CAS)
);
